% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.init}
\alias{ec.init}
\title{Initialize command}
\usage{
ec.init(
  df = NULL,
  group1 = "scatter",
  preset = TRUE,
  load = NULL,
  js = NULL,
  width = NULL,
  height = NULL,
  elementId = NULL,
  renderer = "canvas",
  ...
)
}
\arguments{
\item{df}{A data.frame to be preset as \href{https://echarts.apache.org/en/option.html#dataset}{dataset}, default NULL \cr
For crosstalk df should be of type \code{\link[crosstalk]{SharedData}}.}

\item{group1}{Type of grouped series, or type of first ungrouped serie. Default is 'scatter'. Set to NULL to disable. \cr
If the grouping is on multiple columns, only the first one is used.}

\item{preset}{Disable(FALSE) or enable (TRUE, default) presets xAxis,yAxis,serie for 2D, or grid3D,xAxis3D,yAxis3D,zAxis3D for 3D.}

\item{load}{Name(s) of plugin(s) to load. Could be a character vector or comma-delimited string. default NULL.\cr
Built-in plugins: \cr \itemize{
\item leaflet - Leaflet maps with customizable tiles, see \href{https://github.com/gnijuohz/echarts-leaflet#readme}{source}\cr
\item custom - renderers for \link{ecr.band} and \link{ecr.ebars} \cr
} Plugins with one-time installation (popup prompt): \cr \itemize{
\item 3D - 3D charts and WebGL acceleration, see \href{https://github.com/ecomfe/echarts-gl}{source} and \href{https://echarts.apache.org/en/option-gl.html#series}{docs} \cr
\item world - world map with country boundaries, see \href{https://github.com/apache/echarts/tree/master/test/data/map/js}{source} \cr
\item liquid - liquid fill, see \href{https://github.com/ecomfe/echarts-liquidfill}{source}  \cr
\item gmodular - graph modularity, see \href{https://github.com/ecomfe/echarts-graph-modularity}{source}  \cr
\item wordcloud - cloud of words, see \href{https://github.com/ecomfe/echarts-wordcloud}{source} \cr
} Install you own plugins with \link{ec.plugjs}.}

\item{js}{A Javascript expression to evaluate, default NULL.}

\item{width, height}{A valid CSS unit (like \code{'100\%'},
\code{'500px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{elementId}{Id of the widget, default NULL}

\item{renderer}{\code{'canvas'} (default) or \code{'svg'}.}

\item{...}{Any other arguments to pass to the widget.}
}
\value{
A widget to plot, or to save and expand with more features.
}
\description{
Required to build a chart. In most cases this will be the only command necessary.
}
\details{
Command \emph{ec.init} creates a widget with \code{\link[htmlwidgets]{createWidget}}, then adds some ECharts features to it.\cr
When \emph{ec.init} is chained after a data.frame, a \href{https://echarts.apache.org/en/option.html#dataset}{dataset} is preset. \cr
When the data.frame is grouped and \emph{group1} is not null, more datasets with legend and series are also preset. Grouped series are preset as type \emph{scatter}. \cr
Plugin '3D' presets will not work for 'scatterGL'. Instead, use \emph{preset=FALSE} and set explicitly \emph{xAxis,yAxis}. \cr
Users can delete or overwrite any presets as needed. \cr
}
\examples{
 # basic scatter chart from a data.frame, using presets
 cars \%>\% ec.init()
 
}
