% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echo_package_functions.R
\name{calculate_param}
\alias{calculate_param}
\title{Function to calculate the parameters for the extended harmonic oscillator equation for a specific gene.}
\usage{
calculate_param(current_gene, times, resol, num_reps, tied, is_smooth = FALSE,
  is_weighted = FALSE, low, high, rem_unexpr = FALSE, rem_unexpr_amt = 70,
  jtklist = list(), genes, rem_unexpr_vect, avg_genes, jtk.alt)
}
\arguments{
\item{current_gene}{row number of current gene we want to calculate parameters for}

\item{times}{time points for dataset}

\item{resol}{resolution of time points}

\item{num_reps}{number of replicates}

\item{tied}{if replicate data, whether the replicates are related (paired) or not (unpaired)}

\item{is_smooth}{boolean that indicates whether data should be smoothed or not}

\item{is_weighted}{if there is smoothing, is it weighted (1,2,1) smoothing, or unweighted smoothing (1,1,1)}

\item{low}{the highest frequency we are looking for, in radians (lowest period)}

\item{high}{the lowest frequency we are looking for, in radians (highest period)}

\item{rem_unexpr}{boolean indicating whether genes with less than rem_unexpr_amt percent expression should not be considered}

\item{rem_unexpr_amt}{percentage of expression for which genes should not be considered}

\item{jtklist}{contains the exact p-value distribution for replicate data}

\item{genes}{data frame of genes with the following specifications: first row is column labels, first column has gene labels/names, and all other columns have expression data. This expression data must be ordered by time point then by replicate, and must have evenly spaced time points. Any missing data must have cells left blank.}

\item{rem_unexpr_vect}{vector of booleans indicating whether genes with less than rem_unexpr_amt percent expression should not be considered}

\item{avg_genes}{matrix of average expressions over all replicates for each gene}

\item{jtk.alt}{contains the exact p-value distribution for replicate data with missing data}
}
\value{
res, list which contains:
  \item{results}{a data frame which contains:}
     \item{gene}{gene name}
     \item{conv}{did the fit converge, or descriptor of type of data (constant, unexpressed, etc.)}
     \item{iter}{number of iterations}
     \item{gamma}{forcing coefficient value for fit}
     \item{type_gam}{Type of oscillation (damped, driven, etc.)}
     \item{amplitude}{Amplitude value for fit}
     \item{omega}{Radial frequency for fit}
     \item{period}{Period for fit (in time units)}
     \item{phase.shift}{Phase shift for fit (radians)}
     \item{hours.shift}{Phase shift for fit (hours)}
     \item{tau}{Kendall's tau between original and fitted values}
     \item{y_shift}{Equilibrium shift for fit}
     \item{pval}{P-value calculated based on Kendall's tau}
     \item{original.values}{original values for gene}
     \item{fitted.values}{fitted values for gene}
 \item{jtk.alt}{contains the exact p-value distribution for replicate data with missing data}
}
\description{
Function to calculate the parameters for the extended harmonic oscillator equation for a specific gene.
}
