% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeAverageHausdorffDistance.R
\name{computeAverageHausdorffDistance}
\alias{computeAverageHausdorffDistance}
\title{Average Hausdorff Distance computation.}
\usage{
computeAverageHausdorffDistance(A, B, p = 1, normalize = FALSE,
  dist.fun = computeEuclideanDistance)
}
\arguments{
\item{A}{[\code{matrix}]\cr
First point set (each column corresponds to a point).}

\item{B}{[\code{matrix}]\cr
Second point set (each column corresponds to a point).}

\item{p}{[\code{numeric(1)}]\cr
Parameter p of the average Hausdoff metric.
Default is 1.}

\item{normalize}{[\code{logical(1)}]\cr
Should the front be normalized on basis of \code{B}?
Default is \code{FALSE}.}

\item{dist.fun}{[\code{matrix}]\cr
Distance function to compute distance between points x and y. Expects a single
numeric vector d with the coordinate-wise differences di = (xi - yi).
Default is \code{computeEuclideanDist}.}
}
\value{
[\code{numeric(1)}] Average Hausdorff distance of sets \code{A} and \code{B}.
}
\description{
Computes the average Hausdroff distance measure between two point sets.
}
