% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_E_hertz.R
\name{calculate_E_hertz}
\alias{calculate_E_hertz}
\title{Calculate thermoregulation effectiveness sensu Hertz, Huey & Stevenson}
\usage{
calculate_E_hertz(te, tb, tset_low, tset_up)
}
\arguments{
\item{te}{A vector containing operative temperatures.}

\item{tb}{A vector containing body temperature measurements.}

\item{tset_low}{Lower boundary of a species or population set-point range
that was determined through thermal preference trials in a temperature 
gradient. This may be a named double vector containing the lower boundary 
value, or simply the value itself.}

\item{tset_up}{Upper boundary of the set-point range.}
}
\value{
Effectiveness of temperature regulation (E)
}
\description{
This function calculates the effectiveness of temperature regulation 
(E = 1 - (mean db / mean de)) as described by Hertz et al. (1993). The 
thermal quality of the habitat (de) and accuracy of temperature regulation 
(db) are calculated as part of this formula, so it is not necessary to run 
\code{\link{calculate_de}} and \code{\link{calculate_db}} before running 
this function.
}
\examples{
te <- na.omit(bufbuf[,"te"])
tb <- na.omit(bufbuf[,"tb"])
E <- calculate_E_hertz(te, tb, 19.35, 26.44)

}
\references{
Hertz, P. E., Huey, R. B., & Stevenson, R. D. (1993). Evaluating temperature 
regulation by field-active ectotherms: the fallacy of the inappropriate 
question. The American Naturalist, 142(5), 796-818.
}
\seealso{
\code{\link{calculate_de}} and \code{\link{calculate_db}}.
}
