% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exam2.1.R
\name{Exam2.1}
\alias{Exam2.1}
\title{Example 2.1 from Experimental Design and Analysis for Tree Improvement}
\description{
Exam2.1 is used to  compare two seed lots by using single factor ANOVA.
}
\examples{
library(car)
library(dae)
library(dplyr)
library(emmeans)
library(ggplot2)
library(lmerTest)
library(magrittr)
library(predictmeans)
library(supernova)

data(DataExam2.1)
# Pg. 22
fmtab2.3  <- lm(formula = dbh ~ SeedLot, data = DataExam2.1)
# Pg. 23
anova(fmtab2.3)
supernova(fmtab2.3, type = 1)

# Pg. 23
emmeans(object = fmtab2.3, specs = ~ SeedLot)
emmip(object = fmtab2.3, formula = ~ SeedLot) +
  theme_classic()

}
\references{
\enumerate{
         \item E.R. Williams, C.E. Harwood and A.C. Matheson (2023). \emph{Experimental Design and Analysis for Tree Improvement}.
               CSIRO Publishing (\href{https://www.publish.csiro.au/book/3145/}{https://www.publish.csiro.au/book/3145/}).
             }
}
\seealso{
\code{\link{DataExam2.1}}
}
\author{
\enumerate{
         \item  Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item  Sami Ullah (\email{samiullahuos@gmail.com})
         }
}
