% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment}
\alias{augment}
\alias{augment.log_metric}
\alias{augment.case_metric}
\alias{augment.activity_metric}
\alias{augment.resource_metric}
\alias{augment.resource_activity_metric}
\alias{augment.trace_metric}
\title{Augment Log}
\usage{
augment(metric, log, columns, prefix = "")

\method{augment}{log_metric}(metric, log, columns, prefix = "")

\method{augment}{case_metric}(metric, log, columns, prefix = "")

\method{augment}{activity_metric}(metric, log, columns, prefix = "")

\method{augment}{resource_metric}(metric, log, columns, prefix = "")

\method{augment}{resource_activity_metric}(metric, log, columns, prefix = "")

\method{augment}{trace_metric}(metric, log, columns, prefix = "")
}
\arguments{
\item{metric}{Metric computed by edeaR}

\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}},
\code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.) that was used to compute the \code{metric}.}

\item{columns}{\code{\link{character}} vector: Column names from the \code{metric} that you want to add to the \code{log}. If missing, defaults to all columns.}

\item{prefix}{\code{\link{character}}: Prefix to be added to the newly added metric columns in the \code{log}.}
}
\value{
Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}},
\code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.). Same class as the \code{log} input.
}
\description{
Augment log with results from metric computation.
}
\section{Methods (by class)}{
\itemize{
\item \code{augment(log_metric)}: Augment log metric

\item \code{augment(case_metric)}: Augment case metric

\item \code{augment(activity_metric)}: Augment activity metric

\item \code{augment(resource_metric)}: Augment resource metric

\item \code{augment(resource_activity_metric)}: Augment resource-activity metric

\item \code{augment(trace_metric)}: Augment trace metric

}}
\examples{
\dontrun{
sepsis \%>\%
	throughput_time("case") \%>\%
	augment(sepsis)
}

}
\concept{metrics_other}
