% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/positive_wordcloud.R
\name{PositiveWordcloud}
\alias{PositiveWordcloud}
\title{Creates wordcloud of positive words from 10-K statement.}
\usage{
PositiveWordcloud(word.frq)
}
\arguments{
\item{word.frq}{Word frequency dataframe created using
\link[edgar]{GetWordfrquency} function.}
}
\value{
Function creates wordcloud of positive words containing in the selected
10-K statement.
}
\description{
\code{PositiveWordcloud} creates the wordcloud of positive words from 10-K statement.
}
\details{
PositiveWordcloud function takes words frequency dataframe as an input from
\link[edgar]{GetWordfrquency} function. It compares the words frequency dataframe
with the positive words mentioned in the
Loughran and McDonald's financial sentiment dictionaries
and generates wordcloud using only positive words with their frequencies.
}
\examples{
\dontrun{

PositiveWordcloud(word.frq)
}
}
\references{
Loughran and McDonald's financial Sentiment dictionaries
\url{http://www3.nd.edu/~mcdonald/Word_Lists.html}

Bill McDonald, and Tim Loughran.
Measuring Readability in Financial Disclosures.
Journal of Finance: Volume 69, Issue 4, August 2014

Bill McDonald, and Tim Loughran.
When Is a Liability Not a Liability? Textual Analysis, Dictionaries, and 10-Ks.
Journal of Finance: Volume 66, Issue 1, February 2011
}

