% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/company_search.R
\name{company_search}
\alias{company_search}
\title{SEC Company Search}
\usage{
company_search(x, match = "start", file_number = FALSE, state = "",
  country = "", sic = "", ownership = FALSE, type = "", count = 40,
  page = 1)
}
\arguments{
\item{x}{Name of company to search or file number}

\item{match}{(default: 'start') Either 'start' or 'contains' for where in
the company name to search}

\item{file_number}{(default: FALSE) if set to TRUE, x is treated as a file
number}

\item{state}{(default: '') Limit to a specific state of registration using
2-letter state abbreviations.   Special values:
\describe{
  \item{X1}{The United States}
  \item{A0}{Alberta, Canada}
  \item{A1}{British Columbia, Canada}
  \item{A2}{Manitoba, Canada}
  \item{A3}{New Brunswick, Canada}
  \item{A4}{Newfoundland, Canada}
  \item{A5}{Nova Scotia, Canada}
  \item{A6}{Ontario, Canada}
  \item{A7}{Prince Edward Island, Canada}
  \item{A8}{Quebec, Canada}
  \item{A9}{Saskatchewan, Canada}
  \item{B0}{Yukon, Canada}
}}

\item{country}{2-character country code. The mapping is non-obvious, so
unfortunately the best way to find it is to examine the company search page.}

\item{sic}{SIC Code}

\item{ownership}{boolean for inclusion of company change filings}

\item{type}{Limit to companies with a given filing type - e.g. 'N-PX'}

\item{count}{Number of filings to fetch per page. Valid options are 10, 20,
40, 80, or 100. Other values will result in the closest count.}

\item{page}{Which page of results to return.}
}
\value{
A dataframe of companies
  \itemize{
    \item cik
    \item company_href
    \item name
    \item location
    \item location_href
    \item formerly
    \item sic
    \item sic_description
    \item sic_href
  }
}
\description{
Provides access to the SEC Company Name Search from
\href{https://www.sec.gov/edgar/searchedgar/companysearch.html}{here}
using a company's formal name rather than its common name.
}
\examples{
company_search("Intel")
}
