% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/current_events.R
\name{current_events}
\alias{current_events}
\title{SEC Current Events}
\usage{
current_events(day, form)
}
\arguments{
\item{day}{(0-5) Day to search for current forms. e.g. '2' returns forms
from 2 business days ago.}

\item{form}{Form to return filings (e.g. '10-K')}
}
\value{
A dataframe with one row per company with
       Includes the following columns -
 \itemize{
   \item cik
   \item type
   \item href
   \item company_name
   \item company_href
   \item filing_date
 }
}
\description{
Provides access to the SEC Current Events search tool from
\href{https://www.sec.gov/edgar/searchedgar/currentevents.htm}{here}
}
\examples{
\donttest{
current_events(0, "10-K")[1:5,]
}
}
