% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcc.R
\docType{data}
\name{cpt_hcpcs}
\alias{cpt_hcpcs}
\title{RA-eligible CPT and HCPCS - Table 2}
\format{An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with
6557 rows and 8 columns
\describe{
\item{code}{CPT/HCPCS code}
\item{desc}{Short description of the code}
\item{prior}{Whether or not the code was valid in the prior benefit year}
\item{curr}{Whether or not the code is valid in the current benefit year}
\item{footnote}{Any footnotes included in the CMS DIY file}
}}
\source{
Most recent DIY entry at:
\url{https://www.cms.gov/cciio/Resources/Regulations-and-Guidance/index} \cr
Data import and cleaning at:
\url{https://github.com/ArctiCondor/edgedata/tree/master/data-raw}
}
\usage{
cpt_hcpcs
}
\description{
A dataset containing the Current Procedural Terminology (CPT) and Health Care
Procedure Coding System (HCPCS) codes that determine if a claim is eligible
for risk adjustment.
}
\details{
Risk adjustment requires that claims be face-to-face to count in the HHS-HCC
model. The codes in this dataset denote a face-to-face procedure, so if one
of these codes is found anywhere on a claim, it counts for risk adjustment.
}
\seealso{
Other HCC tables: 
\code{\link{adult_group}},
\code{\link{adult_hcc}},
\code{\link{adult_interaction}},
\code{\link{adult_rxc_hcc_inter}},
\code{\link{cc_hier}},
\code{\link{child_group}},
\code{\link{child_hcc}},
\code{\link{icd_cc}}
}
\concept{HCC tables}
\keyword{datasets}
