% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{formatting}
\alias{formatting}
\alias{print.edbl_design}
\title{Print intermediate experimental design to terminal}
\usage{
\method{print}{edbl_design}(
  x,
  decorate_units = edibble_decorate("units"),
  decorate_trts = edibble_decorate("trts"),
  decorate_rcrds = edibble_decorate("rcrds"),
  decorate_levels = edibble_decorate("levels"),
  decorate_title = edibble_decorate("title"),
  title = NULL,
  ...
)
}
\arguments{
\item{x}{An edibble graph.}

\item{decorate_trts, decorate_units, decorate_rcrds, decorate_levels, decorate_title}{A function applied to the name of treatment, unit, response factors or
design title. The function should return a string. Most often this wraps the name with
ANSI colored text.}

\item{title}{The title of the design.}

\item{...}{Unused.}
}
\description{
This function prints an \code{edbl_graph} object as a tree to terminal.
The variables are color coded (or decorated) with the given options.
Any ANSI coloring or styling are only visible in the console or terminal
outputs that support it. The print output is best used interactively since
any text styling are lost in text or R Markdown output. More details can
be found in \code{vignette("edbl-output", package = "edibble")}.
}
