% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{launchApp}
\alias{launchApp}
\title{Shiny app for exploring census and electorate data}
\usage{
launchApp(age = c("Age00_04", "Age05_14", "Age15_19", "Age20_24", "Age25_34",
  "Age35_44", "Age45_54", "Age55_64", "Age65_74", "Age75_84", "Age85plus"),
  religion = c("Christianity", "Catholic", "Buddhism", "Islam", "Judaism",
  "NoReligion"), other = c("Population", "MedianIncome", "Unemployed",
  "Bachelor", "Postgraduate", "BornOverseas", "Indigenous", "EnglishOnly",
  "OtherLanguageHome", "Married", "DeFacto", "FamilyRatio", "Internet",
  "NotOwned"), palette = c("#1B9E77", "#F0027F", "#E6AB02", "#66A61E",
  "#7570B3", "#D95F02", "#3690C0"))
}
\arguments{
\item{age}{Age variables to show. Variable(s) should match column names from
\link{abs2011}. By default, all variables are shown.}

\item{religion}{Religion variables to show. Variable(s) should match column 
names from \link{abs2011}. By default, all variables are shown.}

\item{other}{Other census variables to show. Variable(s) should match column 
names from \link{abs2011}. By default, all variables are shown.}

\item{palette}{a named character vector of selection colors. The vector names
are used as the display in the drop-down control.}
}
\description{
Shiny app for exploring census and electorate data
}
\examples{
\dontrun{
# for comparing labor/liberal
launchApp(
  age = c("Age20_24", "Age25_34", "Age55_64"),
  religion = c("Christianity", "Catholic", "NoReligion"),
  other = c("Population", "MedianIncome", "Unemployed")
)

# for inspecting highly contested areas
launchApp(
  age = c("Age25_34"),
  religion = c("Christianity", "Catholic", "NoReligion"),
  other = c("NotOwned", "Indigenous", "Population")
)

}
}
\author{
Carson Sievert
}
