% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_odds.R
\name{interpret_odds}
\alias{interpret_odds}
\title{Interpret (log) Odds ratio}
\usage{
interpret_odds(odds, rules = "chen2010", log = FALSE)
}
\arguments{
\item{odds}{Value or vector of (log) odds ratio values.}

\item{rules}{Can be "\verb{chen2010"} (default), \code{"cohen1988"} (through transformation to standardized difference, see \code{\link[=odds_to_d]{odds_to_d()}}) or custom set of \code{\link[=rules]{rules()}}.}

\item{log}{Are the provided values log odds ratio.}
}
\description{
Interpret (log) Odds ratio
}
\examples{
interpret_odds(1)
interpret_odds(c(5, 2))

}
\references{
\itemize{
\item Cohen, J. (1988). Statistical power analysis for the behavioural sciences.
\item Chen, H., Cohen, P., & Chen, S. (2010). How big is a big odds ratio? Interpreting the magnitudes of odds ratios in epidemiological studies. Communications in Statistics—Simulation and Computation, 39(4), 860-864.
\item Sánchez-Meca, J., Marín-Martínez, F., & Chacón-Moscoso, S. (2003). Effect-size indices for dichotomized outcomes in meta-analysis. Psychological methods, 8(4), 448.
}
}
