test_that("elm summary is equivalent to lm summary", {
  m1 <- summary(lm(mpg ~ wt, data = mtcars))
  m2 <- summary(elm(mpg ~ wt, data = mtcars))
  em1 <- round(as.data.frame(m1$coefficients), 4)
  em2 <- as.data.frame(m2$coefficients)
  em2$`Pr(>|t|)` <- as.numeric(em2$`Pr(>|t|)`)
  em2 <- round(em2, 4)
  expect_equal(m1$call$formula, m2$call$formula)
  expect_equal(m1$call$data, m2$call$data)
  expect_equal(m1$terms, m2$terms)
  expect_equal(m1$family, m2$family)
  expect_equal(m1$deviance, m2$deviance)
  expect_equal(m1$aic, m2$aic)
  expect_equal(m1$cov.unscaled, m2$cov.unscaled)
  expect_equal(em1$Estimate, em2$Estimate)
  expect_equal(em1$`Std. Error`, em2$`Std. Error`)
  expect_equal(em1$`t value`, em2$`t value`)
  expect_equal(em1$`Pr(>|t|)`, em2$`Pr(>|t|)`)
})
