% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eha.R
\docType{package}
\name{eha-package}
\alias{eha}
\alias{eha-package}
\title{eha: Event History Analysis}
\description{
Sampling of risk sets in Cox regression, selections in 
        the Lexis diagram, bootstrapping. Parametric proportional 
        hazards fitting with left truncation and right censoring for 
        common families of distributions, piecewise constant hazards, 
        and discrete models. Parametric accelerated failure time models 
        for left truncated and right censored data.
}
\details{
Eha enhances the recommended \pkg{survival} package in several ways, 
see the description. The main applications in mind are demography and 
epidemiology. For standard Cox regression analysis the function 
\code{\link{coxph}} in \pkg{survival} is still recommended. The function 
\code{\link{coxreg}} in \pkg{eha} in fact calls coxph for the standard kind 
of analyses.
}
\references{
Broström, G. (2012). \emph{Event History Analysis with R}, Chapman and Hall/CRC 
Press, Boca Raton, FL.
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/goranbrostrom/eha/issues}
}

}
\author{
\strong{Maintainer}: Göran Broström \email{goran.brostrom@umu.se}

}
