% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ei_preprocessing.R
\name{resolve_missing_vals}
\alias{resolve_missing_vals}
\title{Remove / Impute NAs in an EI dataset}
\usage{
resolve_missing_vals(
  data,
  cand_cols,
  race_cols,
  totals_col,
  na_action = "DROP",
  verbose = TRUE
)
}
\arguments{
\item{data}{A data.frame() object containing precinct-level turnout data by
race and candidate}

\item{cand_cols}{A character vector listing the column names for turnout for
each candidate}

\item{race_cols}{A character vector listing the column names for turnout by
race}

\item{totals_col}{The name of the column containing total votes cast in each
precinct}

\item{na_action}{A string indicating how to handle missing values in EI
columns. Possible values are "DROP" and "MEAN". "DROP" drops all rows
where variables are missing. "MEAN" imputes missing values as the mean of the
column}

\item{verbose}{A boolean indicating whether to give status updates}
}
\value{
A dataframe of inputs to ecological inference without any missing values.
}
\description{
Remove / Impute NAs in an EI dataset
}
