% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series.R
\name{eia_series_metadata}
\alias{eia_series_metadata}
\alias{eia_series_updates}
\alias{eia_series_dates}
\alias{eia_series_range}
\title{EIA series metadata}
\usage{
eia_series_metadata(id, cache = TRUE, key = eia_get_key())

eia_series_updates(id, cache = TRUE, key = eia_get_key())

eia_series_dates(id, cache = TRUE, key = eia_get_key())

eia_series_range(id, cache = TRUE, key = eia_get_key())
}
\arguments{
\item{id}{character, series ID, may be a vector.}

\item{cache}{logical, cache result for duration of R session using memoization.}

\item{key}{API key: character if set explicitly; not needed if key is set globally. See \code{\link{eia_set_key}}.}
}
\value{
a tibble data frame
}
\description{
Make a small request to obtain a data frame containing metadata.
}
\details{
Dates are provided in \code{eia_series_dates} for the convenience of working with the EIA date string format;
for example: maintaining order, generating sequences, computing intervals,
and other operations that work well with dates but would be difficult using arbitrary strings.
Keep in mind that of course these are not real dates, in the sense that you cannot map a year to a specific date.

\code{eia_series_updates} returns a data frame of most recent series update times for \code{id}.
Like the other metadata helpers, this does require an API call to the series to obtain the relevant metadata.
This can be useful if you are only interested in these update times for a specific set of series IDs.
If you need to know the most recent update stamps for a large set of series, you should use \code{\link{eia_updates}}
instead, which makes an API call specifically to the EIA \code{updates} endpoint for specific EIA categories by category ID.
}
\examples{
\dontrun{
# use eia_set_key() to store stored API key
id <- paste0("ELEC.CONS_TOT_BTU.COW-AK-1.", c("A", "Q", "M"))

eia_series_metadata(id)
eia_series_updates(id)
eia_series_dates(id)
eia_series_range(id)
}
}
\seealso{
\code{\link{eia_updates}}
}
