% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series.R
\name{eia_series}
\alias{eia_series}
\title{EIA data series}
\usage{
eia_series(
  id,
  start = NULL,
  end = NULL,
  n = NULL,
  tidy = TRUE,
  cache = TRUE,
  key = eia_get_key()
)
}
\arguments{
\item{id}{character, series ID, may be a vector.}

\item{start}{start date. Providing only a start date will return up to the maximum 100 results if available.}

\item{end}{end date. Providing only an end date will a single result for that date.}

\item{n}{integer, length of series to return ending at most recent value or at \code{end} date if also provided. Ignored if \code{start} is not \code{NULL}.}

\item{tidy}{logical, return a tidier result. See details.}

\item{cache}{logical, cache result for duration of R session using memoization. See details.}

\item{key}{API key: character if set explicitly; not needed if key is set globally. See \code{\link{eia_set_key}}.}
}
\value{
a tibble data frame (or a list, or character, depending on \code{tidy} value)
}
\description{
Obtain EIA data series.
}
\details{
By default, additional processing is done to return a tibble data frame.
Set \code{tidy = FALSE} to return only the initial list result of \code{jsonlite::fromJSON}.
Set \code{tidy = NA} to return the original JSON as a character string.

Set to \code{cache = FALSE} to force a new API call for updated data.
Using \code{FALSE} always makes a new API call and returns the result from the server.
\code{TRUE} uses memoization on a per R session basis, caching the result of the function call in memory for the duration of the R session.
You can reset the entire cache by calling \code{eia_clear_cache()}.
}
\examples{
\dontrun{
# use eia_set_key() to store stored API key
id <- paste0("ELEC.GEN.ALL-AK-99.", c("A", "Q", "M"))

x1 <- eia_series(id[1], start = 2016)
x2 <- eia_series(id[2], n = 5)
x3 <- eia_series(id[3], end = 2016, n = 5)
x1$data[[1]]
x2$data[[1]]
x3$data[[1]]

# multiple series counted as a single API call
x <- eia_series(id, end = 2016, n = 2)
x$data
}
}
\seealso{
\code{\link{eia_clear_cache}}
}
