% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eirm.R
\name{eirm}
\alias{eirm}
\title{Estimating explanatory item response modeling using the GLMM framework}
\usage{
eirm(
  formula,
  data,
  na.action = "na.omit",
  weights = NULL,
  control = glmerControl(optimizer = "optimx", calc.derivs = FALSE, optCtrl =
    list(method = "nlminb", starttests = FALSE, kkt = FALSE))
)
}
\arguments{
\item{formula}{A regression-like formula that defines item responses as a dependent
variable and explanatory predictors as independent predictors.
For example, "response ~ -1 + predictor1 + predictor2". Use -1 in the formula
to avoid the estimation of an intercept parameter.}

\item{data}{A data frame in a long format where there are multiple rows for
each person (i.e., nested data). The data should involve a variable that represents
item responses, a variable that represents persons, and additional predictors to be
used for 'explaining' item responses.}

\item{na.action}{How missing data should be handled (default: "na.omit").}

\item{weights}{Weights to be used in the estimation.}

\item{control}{Control settings for the glmer function in lme4. Note that the optimx
package is used by default to speed up the estimation. For higher accuracy in the
results, the default lme4 optimizers can be used.}
}
\value{
An eirm-class list that includes the EIRM formula used for the estimation, estimated
parameters in the model, ability estimates for persons and other random effects (if any), and
the complete set of results returned from the glmer function. These results can be used for
further analysis and graphics based on lme4.
}
\description{
The eirm function estimates explanatory item response models with item-related and
person-related covariates. The function requires the data to be in a long format where
items are nested within persons. If item responses are polytomous, then the data has to
be reformatted using the \code{\link{polyreformat}}) function.
}
\examples{
\donttest{
data("VerbAgg")
mod0 <- eirm(formula = "r2 ~ -1 + situ + btype + (1|id)", data = VerbAgg)
print(mod0) # To get easiness parameters
print(mod0, difficulty = TRUE) # To get difficulty parameters
plot(mod0)
mod1 <- eirm(formula = "r2 ~ -1 + situ + btype + mode + (1|id)", data = VerbAgg)
print(mod1) # To get easiness parameters
print(mod1, difficulty = TRUE) # To get difficulty parameters
plot(mod1)
}
}
