% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_get.R
\name{wrf_get}
\alias{wrf_get}
\title{Function to read variables of emission files}
\format{array or raster object}
\usage{
wrf_get(file = file.choose(), name = NA, as_raster = F,
  raster_crs = "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
}
\arguments{
\item{file}{name of file interactively (default) or specified}

\item{name}{name of the variable (any variable)}

\item{as_raster}{return a raster instead of a array}

\item{raster_crs}{crs to used if as_raster is TRUE}
}
\description{
Read a variable
}
\examples{
{

# create the folder and emission file
dir.create(file.path(tempdir(), "EMISS"))
wrf_create(wrfinput_dir = system.file("extdata", package = "eixport"),
         wrfchemi_dir = file.path(tempdir(), "EMISS"))

# get the name of created file
files <- list.files(path = file.path(tempdir(), "EMISS"),
                   pattern = "wrfchemi",
                   full.names = TRUE)

# open, put some numbers and write
CO <- wrf_get(file = files[1], name = "E_CO")
CO[] = rnorm(length(CO))
wrf_put(file = files[1], name = "E_CO", POL = CO)
}
}
\seealso{
\code{\link{wrf_plot}} and \code{\link{wrf_put}}
}
\author{
Daniel Schuch
}
