% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elaborator_boxplot.R
\name{elaborator_boxplot}
\alias{elaborator_boxplot}
\title{Boxplot function used in app elaborator}
\usage{
elaborator_boxplot(
  elab_data,
  draw_points_logical,
  same_axes_per_treatment_logical,
  boxplot_color,
  boxplot_border_color,
  lines_data,
  number_plots,
  tol_percentage,
  test_results_logical,
  length_visit2_is_one_logical,
  sort_points,
  incProgress,
  outliers_logical,
  col_lines_options,
  custom_visit
)
}
\arguments{
\item{elab_data}{nested elaborator data with possibly up to three nests 'raw',
'test' and 'differences' grouped by treatment and labparameter}

\item{draw_points_logical}{a logical (TRUE/FALSE) if points should be drawn}

\item{same_axes_per_treatment_logical}{a logical (TRUE/FALSE) if same axes
should be used within lab parameters}

\item{boxplot_color}{vector with color(s) for boxplots}

\item{boxplot_border_color}{vector with color(s) for boxplots border (used
to incidate which visits are used for statistical
tests)}

\item{lines_data}{data frame with connection lines between subjects lab values}

\item{number_plots}{number of plots (used in progress bar (if incProgress is TRUE))}

\item{tol_percentage}{tolerated percentage value}

\item{test_results_logical}{a logical (TRUE/FALSE) if statistical test is used}

\item{length_visit2_is_one_logical}{a logical (TRUE/FALSE) if statistical test
is performed between one or more visits
(this will influence the appearence of the background)}

\item{incProgress}{a logical (TRUE/FALSE) indicates if shiny progress bar is used}

\item{col_lines_options}{option how the lines between visits should be colorized.
Possible options are "first_last","each_visit",
"custom_visits" or "all_grey". In the first three options
decrease is colorized blue and an increase orange.}

\item{custom_visit}{if col_lines_options is "custom_visits" then two visits
need to be selected. Otherwise all lines are grey.}
}
\value{
No return value. Boxplots are generated, used in elaborator.
}
\description{
Boxplot function used in app elaborator
}
\keyword{internal}
