% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{cluster}
\alias{cluster}
\alias{cluster_settings}
\alias{cluster_health}
\alias{cluster_state}
\alias{cluster_stats}
\alias{cluster_reroute}
\alias{cluster_pending_tasks}
\title{Elasticsearch cluster endpoints}
\usage{
cluster_settings(conn, index = NULL, raw = FALSE, callopts = list(),
  verbose = TRUE, ...)

cluster_health(conn, index = NULL, level = NULL,
  wait_for_status = NULL, wait_for_relocating_shards = NULL,
  wait_for_active_shards = NULL, wait_for_nodes = NULL,
  timeout = NULL, raw = FALSE, callopts = list(), verbose = TRUE,
  ...)

cluster_state(conn, index = NULL, metrics = NULL, raw = FALSE,
  callopts = list(), verbose = TRUE, ...)

cluster_stats(conn, index = NULL, raw = FALSE, callopts = list(),
  verbose = TRUE, ...)

cluster_reroute(conn, body, raw = FALSE, callopts = list(), ...)

cluster_pending_tasks(conn, index = NULL, raw = FALSE,
  callopts = list(), verbose = TRUE, ...)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{index}{Index}

\item{raw}{If \code{TRUE} (default), data is parsed to list. If \code{FALSE}, then raw JSON.}

\item{callopts}{Curl args passed on to \link[crul:verb-POST]{crul::verb-POST}}

\item{verbose}{If \code{TRUE} (default) the url call used printed to console.}

\item{...}{Further args passed on to elastic search HTTP API as parameters.}

\item{level}{Can be one of cluster, indices or shards. Controls the details level of the
health information returned. Defaults to cluster.}

\item{wait_for_status}{One of green, yellow or red. Will wait (until the timeout
provided) until the status of the cluster changes to the one provided or better, i.e.
green > yellow > red. By default, will not wait for any status.}

\item{wait_for_relocating_shards}{A number controlling to how many relocating shards
to wait for. Usually will be 0 to indicate to wait till all relocations have happened.
Defaults to not wait.}

\item{wait_for_active_shards}{A number controlling to how many active shards to wait for.
Defaults to not wait.}

\item{wait_for_nodes}{The request waits until the specified number N of nodes is
available. It also accepts >=N, <=N, >N and <N. Alternatively, it is possible to use
ge(N), le(N), gt(N) and lt(N) notation.}

\item{timeout}{A time based parameter controlling how long to wait if one of the
wait_for_XXX are provided. Defaults to 30s.}

\item{metrics}{One or more of version, master_node, nodes, routing_table,
metadata, and blocks. See Details.}

\item{body}{Query, either a list or json.}
}
\description{
Elasticsearch cluster endpoints
}
\details{
metrics param options:
\itemize{
\item version Shows the cluster state version.
\item master_node Shows the elected master_node part of the response
\item nodes Shows the nodes part of the response
\item routing_table Shows the routing_table part of the response. If you supply
a comma separated list of indices, the returned output will only contain the
indices listed.
\item metadata Shows the metadata part of the response. If you supply a comma
separated list of indices, the returned output will only contain the indices
listed.
\item blocks Shows the blocks part of the response
}

Additional parameters that can be passed in:
\itemize{
\item metric A comma-separated list of metrics to display. Possible values: '_all',
'completion', 'docs', 'fielddata', 'filter_cache', 'flush', 'get', 'id_cache', 'indexing',
'merge', 'percolate', 'refresh', 'search', 'segments', 'store', 'warmer'
\item completion_fields A comma-separated list of fields for completion metric (supports
wildcards)
\item fielddata_fields A comma-separated list of fields for fielddata metric (supports
wildcards)
\item fields A comma-separated list of fields for fielddata and completion metric (supports
wildcards)
\item groups A comma-separated list of search groups for search statistics
\item allow_no_indices Whether to ignore if a wildcard indices expression resolves into no
concrete indices. (This includes _all string or when no indices have been specified)
\item expand_wildcards Whether to expand wildcard expression to concrete indices that are
open, closed or both.
\item ignore_indices When performed on multiple indices, allows to ignore missing ones
(default: none)
\item ignore_unavailable Whether specified concrete indices should be ignored when unavailable
(missing or closed)
\item human Whether to return time and byte values in human-readable format.
\item level Return stats aggregated at cluster, index or shard level. ('cluster', 'indices'
or 'shards', default: 'indices')
\item types A comma-separated list of document types for the indexing index metric
}
}
\examples{
\dontrun{
# connection setup
(x <- connect())

cluster_settings(x)
cluster_health(x)

cluster_state(x)
cluster_state(x, metrics = "version")
cluster_state(x, metrics = "nodes")
cluster_state(x, metrics = c("version", "nodes"))
cluster_state(x, metrics = c("version", "nodes", 'blocks'))
cluster_state(x, "shakespeare", metrics = "metadata")
cluster_state(x, c("shakespeare", "flights"), metrics = "metadata")

cluster_stats(x)
cluster_pending_tasks(x)

body <- '{
  "commands": [ 
    {
      "move": {
        "index" : "test", "shard" : 0,
        "from_node" : "node1", "to_node" : "node2"
      }
    },
    {
      "allocate_replica" : {
        "index" : "test", "shard" : 1, "node" : "node3"
      }
    }
  ]
}'
# cluster_reroute(x, body =  body)

cluster_health(x)
# cluster_health(x, wait_for_status = "yellow", timeout = "3s")
}
}
