% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Elasticsearch.R
\name{connect}
\alias{connect}
\title{Set connection details to an Elasticsearch engine.}
\arguments{
\item{host}{(character) The base host, defaults to \code{127.0.0.1}}

\item{port}{(character) port to connect to, defaults to \code{9200}
(optional)}

\item{path}{(character) context path that is appended to the end of the
url. Default: \code{NULL}, ignored}

\item{transport_schema}{(character) http or https. Default: \code{http}}

\item{user}{(character) User name, if required for the connection. You
can specify,  but ignored for now.}

\item{pwd}{(character) Password, if required for the connection. You
can specify, but ignored for now.}

\item{headers}{named list of headers. These headers are used in all requests}

\item{cainfo}{(character) path to a crt bundle, passed to curl option
\code{cainfo}}

\item{force}{(logical) Force re-load of connection details.
Default: \code{FALSE}}

\item{errors}{(character) One of simple (Default) or complete. Simple gives
http code and  error message on an error, while complete gives both http
code and error message,  and stack trace, if available.}

\item{warn}{(logical) whether to throw warnings from the Elasticsearch
server when provided. Pulls warnings from response headers when given.
default: \code{TRUE}. To turn these off, you can set \code{warn=FALSE} or
wrap function calls in \code{\link[=suppressWarnings]{suppressWarnings()}}. You can also see warnings in
headers by using curl verbose.}

\item{...}{additional curl options to be passed in ALL http requests}
}
\description{
Set connection details to an Elasticsearch engine.
}
\details{
The default configuration is set up for localhost access on port
9200, with no username or password.

Running this connection method doesn't ping the ES server, but only prints
your connection details.

All connection details are stored within the returned object. We used to
store them in various env vars, but are now contained within the object
so you can have any number of connection objects and they shouldn't
conflict with one another.
}
\examples{
\dontrun{
# the default is set to 127.0.0.1 (i.e., localhost) and port 9200
(x <- connect())
x$make_url()
x$ping()

# pass connection object to function calls
Search(x, q = "*:*")

# set username/password (hidden in print method)
connect(user = "me", pwd = "stuff")

# set a different host
# connect(host = '162.243.152.53')
# => http://162.243.152.53:9200

# set a different port
# connect(port = 8000)
# => http://localhost:8000

# set a different context path
# connect(path = 'foo_bar')
# => http://localhost:9200/foo_bar

# set to https
# connect(transport_schema = 'https')
# => https://localhost:9200

# set headers
connect(headers = list(a = 'foobar'))

# set cainfo path (hidden in print method)
connect(cainfo = '/some/path/bundle.crt')
}
}
