% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs_bulk_delete.R
\name{docs_bulk_delete}
\alias{docs_bulk_delete}
\title{Use the bulk API to delete documents}
\usage{
docs_bulk_delete(conn, x, index = NULL, type = NULL,
  chunk_size = 1000, doc_ids = NULL, raw = FALSE, ...)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{x}{A list, data.frame, or character path to a file. required.}

\item{index}{(character) The index name to use. Required for data.frame
input, but optional for file inputs.}

\item{type}{(character) The type name to use. If left as NULL, will be
same name as index.}

\item{chunk_size}{(integer) Size of each chunk. If your data.frame is smaller
thank \code{chunk_size}, this parameter is essentially ignored. We write in
chunks because at some point, depending on size of each document, and
Elasticsearch setup, writing a very large number of documents in one go
becomes slow, so chunking can help. This parameter is ignored if you
pass a file name. Default: 1000}

\item{doc_ids}{An optional vector (character or numeric/integer) of document
ids to use. This vector has to equal the size of the documents you are
passing in, and will error if not. If you pass a factor we convert to
character. Default: not passed}

\item{raw}{(logical) Get raw JSON back or not. If \code{TRUE}
you get JSON; if \code{FALSE} you get a list. Default: \code{FALSE}}

\item{...}{Pass on curl options to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Use the bulk API to delete documents
}
\details{
For doing deletes with a file already prepared for the bulk API,
see \code{\link[=docs_bulk]{docs_bulk()}}

Only data.frame's are supported for now.
}
\examples{
\dontrun{
x <- connect()
if (index_exists(x, "foobar")) index_delete(x, "foobar")

df <- data.frame(name = letters[1:3], size = 1:3, id = 100:102)
invisible(docs_bulk(x, df, 'foobar', 'foobar', es_ids = FALSE))
Search(x, "foobar", asdf = TRUE)$hits$hits

# delete using doc ids from the data.frame you used to create
invisible(docs_bulk_delete(x, df, index = 'foobar', type = 'foobar'))
Search(x, "foobar", asdf = TRUE)$hits$total

# delete by passing in doc ids
docs_bulk_delete(x, df, index = 'foobar', type = 'foobar', doc_ids = df$id)
Search(x, "foobar", asdf = TRUE)$hits$total
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-bulk.html}
}
\seealso{
Other bulk-functions: \code{\link{docs_bulk_create}},
  \code{\link{docs_bulk_index}},
  \code{\link{docs_bulk_prep}},
  \code{\link{docs_bulk_update}}, \code{\link{docs_bulk}}
}
\concept{bulk-functions}
