% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seats_local.R
\name{seats_local}
\alias{seats_local}
\title{Download data on the number of seats under dispute in local elections}
\usage{
seats_local(year, uf = "all", encoding = "latin1", temp = TRUE)
}
\arguments{
\item{year}{Election year. For this function, onlye the years of 1996, 2000, 2004, 2008, 2012, 2016 and 2020
are available.}

\item{uf}{Federation Unit acronym (\code{character vector}).}

\item{encoding}{Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). If \code{TRUE}, keep the temporary compressed file for future use (recommended)}
}
\value{
\code{seats_local()} returns a \code{data.frame}.
}
\description{
\code{seats_local()} downloads and aggregates data on the number of seats under dispute in
local elections in Brazil. The function returns a \code{tbl, data.frame} where each observation
corresponds to a municipality office dyad.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\note{
For the elections prior to 2000, some information can be incomplete.
}
\examples{
\dontrun{
df <- seats_local(2000)
}
}
