% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIC.em.glm.R
\name{BIC.em.glm}
\alias{BIC.em.glm}
\title{Calculate the BIC of the em.glm model}
\usage{
\method{BIC}{em.glm}(object, ...)
}
\arguments{
\item{object}{A 'em.glm' class returned by the em.glm function.}

\item{...}{optionally more fitted model objects.}
}
\value{
The BIC score of the model.
}
\description{
Calculate the BIC of the em.glm model
}
\examples{
y <- c(AirPassengers)
n <- length(y)
x <- as.matrix(rep(1, n))
m <- em.glm(x = x, y = y, K = 2, b.init = "random")
BIC(m)

}
