% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/body.R
\name{html}
\alias{html}
\title{Add an HTML body to a message object.}
\usage{
html(
  msg,
  content,
  disposition = "inline",
  charset = "utf-8",
  encoding = NA,
  css_files = c(),
  language = FALSE,
  interpolate = TRUE,
  .open = "{{",
  .close = "}}",
  .envir = NULL
)
}
\arguments{
\item{msg}{A message object.}

\item{content}{A string of message content.}

\item{disposition}{Should the content be displayed inline or as an
attachment? Valid options are \code{"inline"} and \code{"attachment"}. If
set to \code{NA} then will guess appropriate value.}

\item{charset}{What character set is used. Most often either \code{"UTF-8"}
or \code{"ISO-8859-1"}.}

\item{encoding}{How content is transformed to ASCII. Options are
\code{"7bit"}, \code{"quoted-printable"} and \code{"base64"}. Use \code{NA}
or \code{NULL} for no (or "identity") encoding.}

\item{css_files}{Extra CSS files.}

\item{language}{Language of content. If \code{FALSE} then will not include
language field. If \code{TRUE} then will attempt to auto-detect language.
Otherwise will use the specified language.}

\item{interpolate}{Whether or not to interpolate into input using \link[glue]{glue}.}

\item{.open}{The opening delimiter.}

\item{.close}{The closing delimiter.}

\item{.envir}{Environment used for \code{glue} interpolation. Defaults to \code{parent.frame()}.}
}
\value{
A message object.
}
\description{
Add an HTML body to a message object.
}
\examples{
# Inline HTML message.
envelope() \%>\% html("<b>Hello!</b>")

# Read HTML message from a file.
htmlfile <- tempfile(fileext = ".html")
cat("<p>Hello!</p>\n", file = htmlfile)
envelope() \%>\% html(htmlfile)

# You can pass a vector of character. Components will be separated by a
# "\n".
envelope() \%>\% html(c("<b>Hello</b>", "<p>World!</p>"))

# You can also pass a tagList from {htmltools}.
if (requireNamespace("htmltools", quietly = TRUE)) {
  library(htmltools)
  envelope() \%>\% html(tagList(h2("Hello"), p("World!")))
}
}
\seealso{
\code{\link{text}}, \code{\link{render}}
}
