% Generated by roxygen2 (4.0.2): do not edit by hand
\name{info.nests}
\alias{info.nests}
\title{Calculte statistics about nests}
\usage{
info.nests(x, parameters = NULL, fixed.parameters = NULL, SE = NULL,
  temperatures = NULL, derivate = NULL, test = NULL, stopattest = FALSE,
  M0 = NULL, series = "all", TSP.borders = c(21, 26), progress = TRUE,
  embryo.stages = "Caretta caretta", replicate.CI = 100, ref.stage = TRUE)
}
\arguments{
\item{x}{A result file generated by searchR}

\item{parameters}{A set of parameters if result is not provided.}

\item{fixed.parameters}{Another set of parameters if result is not provided.}

\item{SE}{Standard error for each parameter if result is not provided.}

\item{temperatures}{Timeseries of temperatures. Will replace the one in result.}

\item{derivate}{Function used to fit embryo growth: dydt.Gompertz, dydt.exponential or dydt.linear}

\item{test}{Mean and SD of size of hatchlings}

\item{stopattest}{True or False, does the plot stops when proxi of size reaches the mean test size.}

\item{M0}{Measure of hatchling size proxi at laying date}

\item{series}{The name or number of the series to be displayed. Only one series can be displayed at a time.}

\item{TSP.borders}{The limits of TSP}

\item{progress}{If FALSE, the progress bar is not shown (useful for use with Sweave)}

\item{embryo.stages}{The embryo stages. At least TSP.borders stages must be provided if show.TSP is TRUE}

\item{replicate.CI}{Number of randomizations to estimate CI}

\item{ref.stage}{If TRUE, the reference size for stage is the observed one in modelling. If FALSE, it is the field observed size.}
}
\value{
A list with informations about thermosensitive period length for the series of nests analyzed
}
\description{
Calculate statistics about nests\cr
The embryo.stages is a list with stage numbers and relative size as compared to final size at the beginning of the stage.\cr
For example embryo.stages=list(number=21:30, size=c(8.4, 9.4, 13.6, 13.8, 18.9, 23.5, 32.2, 35.2, 35.5, 38.5)/39.33) indicates that the stages 21 begins at the relative size of 8.4/39.33 series can be indicated as the name of the series, its number or TRUE or FALSE. "all" indicates that all series must be printed.
}
\details{
Calculate statistics about nests
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p)
info.nests(resultNest_4p, series=1,
	SE=c(DHA=1.396525, DHH=4.101217, T12H=0.04330405, Rho25=1.00479))
# to get info for all nests at the same time, use
infoall <- info.nests(resultNest_4p, series="all")
# it is easier to use after dataframe conversion
infoall.df <- as.data.frame(infoall$summary)
}
}
\author{
Marc Girondot
}

