% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/resultNest_newp.R
\docType{data}
\name{resultNest_newp}
\alias{resultNest_newp}
\title{Fit using the nest database with anchored parameters}
\format{A list with fitted information about data(nest) with anchored parameters}
\usage{
resultNest_newp
}
\description{
Fit using the nest database with anchored parameters
}
\details{
Result of the fit using the nest database with anchored parameters
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
# the package polynom must be present
if (is.element('polynom', installed.packages()[,1]) == FALSE) {
install.packages('polynom')
}
newp <- GenerateAnchor(nests=formated, number.anchors=7)
pfixed <- c(rK=2.093313)
resultNest_newp <- searchR(parameters=newp, fixed.parameters=pfixed,
  temperatures=formated, derivate=dydt.Gompertz, M0=1.7,
	test=c(Mean=39.33, SD=1.92), method = "BFGS", maxiter = 200)
data(resultNest_newp)
plotR(resultNest_newp)
}
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\references{
Girondot, M., & Kaska, Y. (2014). A model to predict
            the thermal reaction norm for the embryo growth rate
            from field data. Journal of Thermal Biology, 45, 96-102.
            doi: 10.1016/j.jtherbio.2014.08.005
}
\keyword{datasets}

