% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightmaxentropy.R
\name{weightmaxentropy}
\alias{weightmaxentropy}
\title{Search for the weights of the nests which maximize the entropy of nest temperatures distribution}
\usage{
weightmaxentropy(
  temperatures = stop("Temperature data must be provided !"),
  weight = NULL,
  entropy.method = entropy::entropy.empirical,
  plot = TRUE,
  control_optim = list(trace = 0, maxit = 500),
  control_plot = NULL,
  control_entropy = NULL,
  col = c("black", "red")
)
}
\arguments{
\item{temperatures}{Timeseries of temperatures formated using FormatNests()}

\item{weight}{A named vector of the initial weight search for each nest for likelihood estimation}

\item{entropy.method}{Entropy function, for example entropy::entropy.empirical. See package entropy for description}

\item{plot}{Do the plot of temperatures before and after weight must be shown ? TRUE or FALSE}

\item{control_optim}{A list with control paramaters for optim function}

\item{control_plot}{A list with control paramaters for plot function}

\item{control_entropy}{A list with control paramaters for entropy function}

\item{col}{Colors for unweighted and weighted distributions}
}
\value{
A named vector of weights
}
\description{
Search for the weights of the nests which maximize the entropy of nest temperatures distribution. Entropy is measured by Shanon index.\cr
Entropy method must be entropy.empirical because it is the only method insensitive to scaling.\cr
If no weight is given, the initial weight is uniformly distributed.\cr
Use control_optim=list(trace=0) for not show progress of search report.
}
\details{
Search for the weights of the nests which maximize the entropy of nest temperatures distribution
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
w <- weightmaxentropy(formated, control_plot=list(xlim=c(20,36)))
x <- structure(c(120.940334922916, 467.467455887442,  
	306.176613681557, 117.857995419495),  
	.Names = c("DHA", "DHH", "T12H", "Rho25"))
# pfixed <- c(K=82.33) or rK=82.33/39.33
pfixed <- c(rK=2.093313)
# K or rK are not used for dydt.linear or dydt.exponential
resultNest_4p_weight <- searchR(parameters=x,  
	fixed.parameters=pfixed, temperatures=formated,  
	integral=integral.Gompertz, M0=1.7, hatchling.metric=c(Mean=39.33, SD=1.92),  
	method = "BFGS", weight=w)
data(resultNest_4p_weight)
plotR(resultNest_4p_weight, ylim=c(0,0.50), xlim=c(15, 35))
# Standard error of parameters can use the GRTRN_MHmcmc() function
}
}
\author{
Marc Girondot
}
