% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate.R
\name{emend_translate}
\alias{emend_translate}
\title{Translate text from one language to another.}
\usage{
emend_translate(text, to = "English", chat = get_default_chat())
}
\arguments{
\item{text}{The text to translate.}

\item{to}{The language to translate to. The default is "English".}

\item{chat}{An ellmer Chat object.}
}
\value{
A character vector of translated text.
}
\description{
Translate text from one language to another.
}
\examples{
\donttest{
chat <- ellmer::chat_ollama(model = "llama3.1:8b", seed = 0, echo = "none")
emend_translate(c("\u733F\u3082\u6728\u304B\u3089\u843D\u3061\u308B", 
                  "\u4F60\u597D", "bon appetit"), chat = chat)
}

}
