% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgfit.R
\docType{methods}
\name{infer_lambda}
\alias{infer_lambda}
\alias{infer_lambda,hspec-method}
\title{Infer lambda process with given Hawkes model and realized path}
\usage{
infer_lambda(
  object,
  inter_arrival = NULL,
  type = NULL,
  mark = NULL,
  N = NULL,
  Nc = NULL,
  lambda0 = NULL,
  N0 = NULL
)

\S4method{infer_lambda}{hspec}(
  object,
  inter_arrival = NULL,
  type = NULL,
  mark = NULL,
  N = NULL,
  Nc = NULL,
  lambda0 = NULL,
  N0 = NULL
)
}
\arguments{
\item{object}{\code{\link{hspec-class}}. This object includes the parameter values.}

\item{inter_arrival}{inter-arrival times of events. Includes inter-arrival for events that occur in all dimensions. Start with zero.}

\item{type}{a vector of dimensions. Distinguished by numbers, 1, 2, 3, and so on. Start with zero.}

\item{mark}{a vector of mark (jump) sizes. Start with zero.}

\item{N}{Hawkes process. if not provided, then generate using inter_arrival and type.}

\item{Nc}{mark accumulated Hawkes process. if not provided, then generate using inter_arrival, type and mark.}

\item{lambda0}{the initial values of lambda component. Must have the same dimensional matrix (n by n) with hspec.}

\item{N0}{the initial values of N.}
}
\value{
hreal S3-object, the Haweks model with inferred intensity, lambda
}
\description{
This method compute the inferred lambda process and returns it as \code{hreal} form.
If we have realized path of Hawkes process and its parameter value, then we can compute the inferred lambda processes.
Similarly with other method such as \code{hfit}, the input arguments are \code{inter_arrival}, \code{type}, \code{mark},
or equivalently, \code{N} and \code{Nc}.
}
\examples{
mu <- c(0.1, 0.1)
alpha <- matrix(c(0.2, 0.1, 0.1, 0.2), nrow=2, byrow=TRUE)
beta <- matrix(c(0.9, 0.9, 0.9, 0.9), nrow=2, byrow=TRUE)
h <- new("hspec", mu=mu, alpha=alpha, beta=beta)
res <- hsim(h, size=100)
res2 <- infer_lambda(h, res$inter_arrival, res$type)

}
