% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reshape-result.r
\name{get_tuning}
\alias{get_tuning}
\title{Extract parameter tuning statistics}
\usage{
get_tuning(object)
}
\arguments{
\item{object}{Fitted model or modeling procedure}
}
\value{
A data frame of tuning statistics in long format.
}
\description{
Extract parameter tuning statistics
}
\examples{
procedure <- modeling_procedure("randomForest",
    parameter = list(mtry = c(1, 3),
                     nodesize = c(4, 10)))
model <- fit(procedure, x=iris[-5], y=iris$Species)
get_tuning(model)

options(emil_max_indent=4)
ho <- resample("holdout", iris$Species, nfold=5)
result <- evaluate(procedure, iris[-5], iris$Species, resample=ho,
                   .save=c(model=TRUE))
get_tuning(result)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}

