#' Data from ICU admissions.
#'
#' A dataset containing selected data from some ICU (intensive care units) admissions and its outcomes at the year 2013 used in the ORCHESTRA study.
#'
#' \itemize{
#'   \item \code{Unit} The name of the ICU unit.
#'   \item \code{Age} Patient age.
#'   \item \code{Gender} Male = 1, Female = 0
#'   \item \code{UnitAdmissionDateTime} ICU unit admission date and time.
#'   \item \code{UnitDischargeDateTime} ICU unit discharge date and time.
#'   \item \code{UnitDischargeName} Unit admission outcome. Death = 1, or Discharge = 0.
#'   \item \code{UnitDestinationName} ICU unit destination after discharge.
#'   \item \code{HospitalAdmissionDate} Hospital admission date.
#'   \item \code{HospitalDischargeDate} Hospital discharge date.
#'   \item \code{HospitalDischargeName} Hospital admission outcome. Death = 1, or Discharge = 0.
#'   \item \code{LengthHospitalStayPriorUnitAdmission} Hospital length of stay before unit admission.
#'   \item \code{AdmissionSourceName} The origin of the patient before ICU unit admission.
#'   \item \code{AdmissionTypeName_pri} Admission for  or Clinical treatment (1) Elective surgery (2), or Urgent surgery (3).
#'   \item \code{AdmissionReasonName_pri} Main diagnosis groups.
#'   \item \code{Vasopressors_D1} Vasopressors use at ICU first day admission? No = No, Yes = 1
#'   \item \code{IsMechanicalVentilation1h} Required mechanichal ventilation at 1st hour of admission. No = 0, Yes = 1.
#'   \item \code{CharlsonComorbidityIndex} Charlson comorbidity index.
#'   \item \code{Saps3Points} SAPS 3 score
#'   \item \code{Saps3DeathProbabilityStandardEquation} SAPS 3 estimated probability
#'   \item \code{SofaScore} SOFA score.
#' }
#'
#' @format A data frame with 13709 rows and 24 variables
#' @source Organizational characteristics, outcomes, and resource use in 78 Brazilian intensive care units: the ORCHESTRA study. Intensive Care Med. 2015 Dec;41(12):2149-60.




"icu"
#> [1] "icu"
