% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.DBconfig.EMUwebAppConfig.R
\name{SetGetSignalCanvasesOrder}
\alias{SetGetSignalCanvasesOrder}
\alias{get_signalCanvasesOrder}
\alias{set_signalCanvasesOrder}
\title{Set / Get signalCanvasesOrder of / to / from emuDB}
\usage{
set_signalCanvasesOrder(emuDBhandle, perspectiveName, order)

get_signalCanvasesOrder(emuDBhandle, perspectiveName)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{perspectiveName}{name of perspective}

\item{order}{character vector containig names of ssffTrackDefinitions or "OSCI" / "SPEC"}
}
\description{
Set / Get signalCanvasesOrder array that specifies which signals are 
displayed in the according perspective by the EMU-webApp. An entry in this character vector 
refers to either the name of an ssffTrackDefinition or a predefined string: \code{"OSCI"} which 
represents the oscillogram or \code{"SPEC"} which represents the 
spectrogram. For more information on the structural elements of an emuDB 
see \code{vignette{emuDB}}.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

# get signal canvas order of the "default"
# perspective of the ae emuDB
get_signalCanvasesOrder(emuDBhandle = ae, 
                        perspectiveName = "default")
                        
}

}
\keyword{DBconfig}
\keyword{Emu}
\keyword{database}
\keyword{emuDB}

