% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.DBconfig.R
\name{AddListRemoveLevelDefinitions}
\alias{AddListRemoveLevelDefinitions}
\alias{add_levelDefinition}
\alias{list_levelDefinitions}
\alias{remove_levelDefinition}
\title{Add / List / Remove level definition to / of / from emuDB}
\usage{
add_levelDefinition(emuDBhandle, name, type, verbose = T)

list_levelDefinitions(emuDBhandle)

remove_levelDefinition(emuDBhandle, name, verbose = T)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{name}{name of level definition}

\item{type}{type of level definition ("SEGMENT","EVENT","ITEM")}

\item{verbose}{Show progress bars and further information}
}
\description{
Add / List / Remove database operation functions for level definitions. 
A level is a more general term for what is often referred to as a "tier". 
It is more general in the sense that people usually 
expect tiers to contain time information. Levels 
can either contain time information if they are of the 
type "EVENT" or of the type "SEGMENT" but are timeless 
if they are of the type "ITEM". For more information 
on the structural elements of an emuDB see \code{vignette(emuDB)}.
Note that a level cannot be removed, if it contains instances of annotation items
or if it is linked to another level. Further note, renaming a level definition 
can be done using \code{\link{rename_attributeDefinition}}.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

# add level called "Phonetic2" to the ae emuDB
# that could for example contain the transcriptions of a second annotator
add_levelDefinition(emuDBhandle = ae,
                    name = "Phonetic2",
                    type = "SEGMENT")
                    
# list level definition of ae emuDB
list_levelDefinitions(emuDBhandle = ae)

# remove newly added level definition
remove_levelDefinitions(emuDBhandle = ae,
                        name = "Phonetic2")
}

}
\keyword{Emu}
\keyword{database}
\keyword{emuDB}
\keyword{schema}

