% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padronizar_logradouros_completos.R
\name{padronizar_logradouros_completos}
\alias{padronizar_logradouros_completos}
\title{Padronizar logradouros completos}
\usage{
padronizar_logradouros_completos(
  enderecos,
  campos_do_logradouro = correspondencia_logradouro(),
  manter_cols_extras = TRUE,
  checar_tipos = FALSE
)
}
\arguments{
\item{enderecos}{Um dataframe. Os endereços a serem padronizados. Ao menos
uma de suas colunas deve corresponder a um campo do logradouro.}

\item{campos_do_logradouro}{Um vetor nomeado de caracteres. A correspondência
entre os campos a serem padronizados (nomes do vetor) e as colunas que os
representam no dataframe (valores do vetor). A função
\code{correspondencia_logradouro()} facilita a criação deste vetor, fazendo
também algumas verificações do conteúdo imputado. Caso deseje criar o vetor
manualmente, note que seus nomes devem ser os mesmos nomes dos parâmetros
da função \code{correspondencia_logradouro()}.}

\item{manter_cols_extras}{Um logical. Se colunas não especificadas em
\code{campos_do_logradouro} devem ser mantidas no output ou não (por exemplo,
uma coluna com a informação de bairro ou com o id do conjunto de dados
sendo padronizado). Por padrão, \code{TRUE}.}

\item{checar_tipos}{Um logical. Se a ocorrência de duplicatas entre os tipos
e nomes dos logradouros deve ser verificada ao combiná-los (por exemplo,
quando o tipo é descrito como "RUA" e o nome é descrito como "RUA
BOTAFOGO"). Por padrão, \code{FALSE}.}
}
\value{
Caso \code{manter_cols_extras} seja \code{TRUE}, o mesmo dataframe de input,
mas sem as colunas descrevendo o logradouro e com uma coluna padronizada
adicional \code{logradouro_completo}. Caso \code{manter_cols_extras} seja \code{FALSE}, um
dataframe de apenas uma coluna, \code{logradouro_completo}.
}
\description{
Padroniza o logradouro completo a partir de diversos campos (tipo de
logradouro, nome do logradouro e número), garantindo a consistência da
informação.
}
\examples{
enderecos <- data.frame(
  id = 1,
  tipoLogradouro = "r",
  logradouro = "ns sra da piedade",
  nroLogradouro = 20,
  complemento = "qd 20",
  cep = 25220020,
  bairro = "jd botanico",
  codmun_dom = 3304557,
  uf_dom = "rj"
)

campos <- correspondencia_logradouro(
  tipo_de_logradouro = "tipoLogradouro",
  nome_do_logradouro = "logradouro",
  numero = "nroLogradouro"
)

padronizar_logradouros_completos(enderecos, campos)

padronizar_logradouros_completos(
  enderecos,
  campos,
  manter_cols_extras = FALSE
)

enderecos <- data.frame(
  tipoLogradouro = "r",
  logradouro = "r ns sra da piedade",
  nroLogradouro = 20
)
padronizar_logradouros_completos(enderecos, campos, checar_tipos = TRUE)

}
