% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmsToDecimal.r
\name{dmsToDecimal}
\alias{dmsToDecimal}
\title{Convert geographic coordinates in degrees-minutes-second to decimal format}
\usage{
dmsToDecimal(dd, mm, ss, hemis = NULL)
}
\arguments{
\item{dd}{Numeric. Degrees longitude or latitude. Can be a decimal value.}

\item{mm}{Numeric. Minutes longitude or latitude. Can be a decimal value.}

\item{ss}{Numeric. Second longitude or latitude. Can be a decimal value.}

\item{hemis}{Character or \code{NULL} (default). "N" (north), "S" (south), "E" (east), or "W" (west). If left as \code{NULL}, then the value returned will always be positive, even if it is in the western or southern hemisphere.}
}
\value{
Numeric.
}
\description{
This function converts geographic coordinates in degrees-minutes-seconds (DD-MM-SS) format to decimal format.
}
\examples{
dmsToDecimal(38, 37, 38) # latitude of St. Louis, Missouri, USA
dmsToDecimal(38, 37, 38, 'N') # latitude of St. Louis, Missouri, USA
dmsToDecimal(90, 11, 52.1) # longitude of St. Louis, Missouri, USA
dmsToDecimal(90, 11, 52.1, 'W') # longitude of St. Louis, Missouri, USA
}
