% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_niche_signal.R
\name{plot_niche_signal}
\alias{plot_niche_signal}
\alias{plot_niche_signal_univariate}
\alias{plot_niche_signal_permanova}
\title{Plot Niche Signal results}
\usage{
plot_niche_signal(niche_signal_list, statistic = "mean",
                  variables = NULL, ellipses = FALSE, level = 0.99,
                  breaks = "Sturges", main = "", xlab = NULL, ylab = NULL,
                  h_col = "lightgray", h_cex = 0.8, lty = 2, lwd = 1,
                  l_col = c("blue", "black"), e_col = c("black", "red"),
                  pch = 19, pt_cex = c(1.3, 0.8), pt_col = c("black", "red"),
                  ...)

plot_niche_signal_univariate(niche_signal_univariate_list, statistic = "mean",
                             breaks = "Sturges", main = "", xlab = NULL,
                             ylab = "Frequency", h_col = "lightgray",
                             h_cex = 0.8, lty = 2, lwd = 1,
                             l_col = c("blue", "black"), ...)

plot_niche_signal_permanova(niche_signal_permanova_list, variables = NULL,
                           ellipses = FALSE, level = 0.99, main = "",
                           xlab = NULL, ylab = NULL,
                           e_col = c("black", "red"), lty = 2, lwd = 1,
                           pch = 19, pt_cex = c(1.3, 0.8),
                           pt_col = c("black", "red"), ...)
}
\arguments{
\item{niche_signal_list}{list of results from niche_signal.}

\item{statistic}{(character) name of the statistic for which results will be
explored when results come for univariate analysis. Default = "mean". Options
are: "mean", "median", "SD", and "range".}

\item{variables}{(character) name of variables to used in plots when
results come from analysis using the \code{permanova} method. The default, NULL,
uses the first two variables.}

\item{ellipses}{(logical) whether to use ellipses to represent all and
positive data when results come from PERMANOVA. The default, FALSE, plots
points instead.}

\item{level}{(numeric) value from 0 to 1 representing the limit of
the ellipse to be plotted. Default = 0.99.}

\item{breaks}{breaks in the histogram as in \code{\link[graphics]{hist}}.
Default = "Sturges".}

\item{main}{(character) title for plot. Default = "".}

\item{xlab}{(character) x axis label. Default = NULL. For results from
PERMANOVA, appropriate variable names are used.}

\item{ylab}{(character) y axis label. Default = NULL. For univariate
results, the default turn into "Frequency". For results from PERMANOVA,
appropriate variable names are used.}

\item{h_col}{a color to be used to fill the bars of histograms.
Default = "lightgray".}

\item{h_cex}{(numeric) value by which plotting text and symbols should be
magnified relative to the default in histograms. Default = 0.8.}

\item{lty}{(numeric) line type. See options in \code{\link[graphics]{par}}.
Default = 2. A vector of length = 2 can be used, in order, all and positive.}

\item{lwd}{(numeric) line width. See options in \code{\link[graphics]{par}}.
Default = 1. A vector of length = 2 can be used, in order, all and positive.}

\item{l_col}{line color for observed value of positives and confidence
intervals. Default = c("blue", "black").}

\item{e_col}{color of ellipse lines for all and positive data.
Default = c("black", "red").}

\item{pch}{point type. See options in \code{\link[graphics]{points}}.
Default = 19. A vector of length = 2 can be used, in order, all and positive.}

\item{pt_cex}{(numeric) value by which points will be magnified. Values
for all and positive points are recommended. Default = c(1.3, 0.8).}

\item{pt_col}{color for points. Values for all and positive points are
recommended. Default = c("black", "red").}

\item{...}{other plotting arguments to be used.}

\item{niche_signal_univariate_list}{list of results from niche_signal_univariate.}

\item{niche_signal_permanova_list}{list of results from niche_signal_permanova.}
}
\value{
A plot.
}
\description{
Plots to interpret results from niche_signal tests
(Cobos & Peterson (2022) \url{doi:10.17161/bi.v17i.15985}).
}
\examples{
# Load species occurrences and environmental data.
data("enm_data", package = "enmpa")
head(enm_data)

# Detection of niche signal using an univariate non-parametric test
sn_bio1 <- niche_signal(data = enm_data,
                        variables = "bio_1",
                        condition = "Sp",
                        method = "univariate")

plot_niche_signal(sn_bio1, variables = "bio_1")

sn_bio12 <- niche_signal(data = enm_data,
                         variables = "bio_12",
                         condition = "Sp",
                         method = "univariate")

plot_niche_signal(sn_bio12, variables = "bio_12")
}
