% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich-package.R
\docType{package}
\name{enrichwith}
\alias{enrichwith}
\alias{enrichwith-package}
\title{Methods to enrich list-like R objects with extra components}
\description{
The enrichwith package provides the \code{\link{enrich}} method to
enrich list-like R objects with new, relevant components. The
resulting objects preserve their class, so all methods associated
to them still apply. The package can also be used to produce
customisable source code templates for the structured
implementation of methods to compute new components
}
\details{
Depending on the object, enriching it can be a tedious task. The
\pkg{enrichwith} package aims to streamline the task into 3 simple
steps:

\enumerate{

\item Use \code{\link{create_enrichwith_skeleton}} to produce a
customisable enrichwith template.

\item Edit the \code{compute_*} functions by adding the specific
code that calculates the components.

\item Finalise the documentation and/or include more examples.
}

The first step results in a template that includes all necessary
functions to carry out the enrichment. The second step is where the
user edits the template and implements the calculation of the
components that the object will be enriched with. Specifically,
each \code{compute_*} function takes as input the object to be
enriched and returns the corresponding new component to be added to
the object.

Everything else (for example, mapping between the enrichment
options and the components that the enriched object will have,
checks that an enrichment option exists, listing enrichment
options, enriching the object, and so on) is taken care of by the
methods in \pkg{enrichwith}.

Developers can either put their enrichwith templates in their
packages or are welcome to contribute their template to enrichwith,
particularly if that extends core R objects.
}

