% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_publish.R
\name{theme_publish}
\alias{theme_publish}
\title{ggplot2 theme for scientific publications}
\usage{
theme_publish(base_size = 12, base_family = "", line_size = 0.25, ...)
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{line_size}{base line size for, e.g. for ticks and axes}

\item{\dots}{further arguments to be passed to \code{\link[ggplot2]{theme_bw}}}
}
\description{
Themes set the general aspect of the plot such as the color of the
background, grid lines, the size and color of fonts. This particular theme is
based on the classic dark-on-light ggplot2 \code{\link[ggplot2]{theme_bw}}
and has been used for scientific publications.
}
\examples{
require(ggplot2)
p <- ggplot(mtcars) + geom_point(aes(x = wt, y = mpg,
     colour=factor(gear))) + facet_wrap( ~ am)
p
p + theme_publish()

}
\seealso{
\code{\link[ggplot2]{ggtheme}}
\code{\link[ggplot2]{theme_bw}}
}
\author{
Zacharias Steinmetz
}
