% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sorption.R
\name{sorption}
\alias{sorption}
\title{Sorption isotherms}
\usage{
sorption(x, par, type = "freundlich")
}
\arguments{
\item{x}{a numeric vector containing the concentration(s) of the dissolved
substance.}

\item{par}{a numeric vector specifying the function parameters, see examples
for details and correct order.}

\item{type}{a character string indicating the type of sorption isotherm to be used:
\code{"linear"} for the linear type,
\code{"freundlich"} for the Freundlich isotherm,
\code{"langmuir"} for the Langmuir isotherm,
\code{"BET"} for the BET model according to Brunauer, Emmet, and Teller
\code{"redlich"} for the Redlich-Peterson isotherm.}
}
\description{
This function returns the concentration of a substance sorbed to a surface
boundary after an equilibrium has established at constant temperature given
the concentration(s) \code{x} of the dissolved substance.
}
\examples{
sorption(1:5, par = c(Kd = 2.5), type = "linear")
sorption(1:5, par = c(K = 4, n = 0.6), type = "freundlich")
sorption(1:5, par = c(KL = 2, qmax = 10), type = "langmuir")
sorption(1:5, par = c(K = 50, qmax = 10, Csat = 10), type = "BET")
sorption(1:5, par = c(A = 30, B = 0.8), type = "redlich")

}
\references{
Atkins, P.W. (2001). \emph{Physical chemistry}, Oxford University Press, Oxford.
}
\author{
Zacharias Steinmetz
}
