% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recplot.R
\name{enve.recplot}
\alias{enve.recplot}
\title{Enveomics: Recruitment Plots}
\usage{
enve.recplot(prefix, id.min = NULL, id.max = NULL, id.binsize = NULL,
  id.splines = 0, id.metric = "id", id.summary = "sum",
  pos.min = 1, pos.max = NULL, pos.binsize = 1000, pos.splines = 0,
  rec.col1 = "white", rec.col2 = "black", main = NULL,
  contig.col = grey(0.85), ret.recplot = FALSE, ret.hist = FALSE,
  ret.mode = FALSE, id.cutoff = NULL, verbose = TRUE, ...)
}
\arguments{
\item{prefix}{Path to the prefix of the BlastTab.catsbj.pl output files. At
least the files \strong{.rec} and \strong{.lim} must exist with this prefix.}

\item{id.min}{Minimum identity to be considered. By default, the minimum detected
identity. This value is a percentage.}

\item{id.max}{Maximum identity to be considered. By default, 100\%.}

\item{id.binsize}{Size of the identity bins (vertical histograms). By default, 0.1 for
identity metrics and 5 for bit score.}

\item{id.splines}{Smoothing parameter for the splines in the identity histogram. Zero (0) for no
splines. A generally good value is 1/2. If non-zero, requires the \pkg{stats} package.}

\item{id.metric}{Metric of identity to be used (Y-axis). 
It can be any unambiguous prefix of:
\itemize{
\item "identity"
\item "corrected identity" 
\item "bit score"}}

\item{id.summary}{Method used to build the identity histogram (Horizontal axis of the right panel).
It can be any unambiguous prefix of: 
\itemize{
\item "sum"
\item "average" 
\item "median"
\item "90\% lower bound"
\item "90\% upper bound"
\item "95\% lower bound"
\item "95\% upper bound" }
The last four options
correspond to the upper and lower boundaries of the 90\% and 95\% empirical confidence
intervals.}

\item{pos.min}{Minimum (leftmost) position in the reference (concatenated) genome (in bp).}

\item{pos.max}{Maximum (rightmost) position in the reference (concatenated) genome (in bp).
By default: Length of the genome.}

\item{pos.binsize}{Size of the position bins (horizontal histograms) in bp.}

\item{pos.splines}{Smoothing parameter for the splines in the position histogram. Zero (0) for no splines.
If non-zero, requires the stats package.}

\item{rec.col1}{Lightest color in the recruitment plot.}

\item{rec.col2}{Darkest color in the recruitment plot.}

\item{main}{Title of the plot.}

\item{contig.col}{Color of the Contig boundaries. Set to \code{NA} to ignore Contig boundaries.}

\item{ret.recplot}{Indicates if the matrix of the recruitment plot is to be returned.}

\item{ret.hist}{Ignored, for backwards compatibility.}

\item{ret.mode}{Indicates if the mode of the identity is to be computed. It requires the 
\pkg{modeest} package.}

\item{id.cutoff}{Minimum identity to consider an alignment as "top". By default, it is 0.95 for the
identity metrics and 95\% of the best scoring alignment for bit score.}

\item{verbose}{Indicates if the function should report the advance.}

\item{...}{Any additional graphic parameters to be passed to plot for all panels except the
recruitment plot (lower-left).}
}
\value{
Returns a list with the following elements:

\describe{
\item{\code{pos.marks}}{Midpoints of the position histogram.}
\item{\code{id.matrix}}{Midpoints of the identity histogram.}
\item{\code{recplot}}{Matrix containing the recruitment plot values 
     (if \code{ret.recplot=TRUE}).}
\item{\code{id.mean}}{Mean identity.}
\item{\code{id.median}}{Median identity.}
\item{\code{id.mode}}{Mode of the identity (if \code{ret.mode=TRUE}). Deprecated.}
\item{\code{id.hist}}{Values of the identity histogram (if \code{ret.hist=TRUE}).}
\item{\code{pos.hist.low}}{Values of the position histogram (depth) with "low"
     identity (i.e., below id.cutoff) (if \code{ret.hist=TRUE}).}
\item{\code{pos.hist.top}}{Values of the position histogram (depth) with "top"
     identity (i.e., above id.cutoff) (if \code{ret.hist=TRUE}).}
\item{\code{id.max}}{Value of \code{id.max}. This is returned because 
     \code{id.max=NULL} may vary.}
\item{\code{id.cutoff}}{Value of \code{id.cutoff}. 
     This is returned because \code{id.cutoff=NULL} may vary.}
\item{\code{seqdepth.mean.top}}{Average sequencing depth with identity above 
     \code{id.cutoff}.}
\item{\code{seqdepth.mean.low}}{Average sequencing depth with identity below 
     \code{id.cutoff}.} 
\item{\code{seqdepth.mean.all}}{Average sequencing depth without identity filtering.}
\item{\code{seqdepth.median.top}}{Median sequencing depth with identity above 
     \code{id.cutoff}.}
\item{\code{seqdepth.median.low}}{Median sequencing depth with identity below 
     \code{id.cutoff}.}
\item{\code{seqdepth.median.all}}{Median sequencing depth without identity filtering.}
\item{\code{id.metric}}{Full name of the used identity metric.}
\item{\code{id.summary}}{Full name of the summary method used to build the identity plot.}}
}
\description{
Produces recruitment plots provided that BlastTab.catsbj.pl has
been previously executed. Requires the \pkg{gplots} library.
}
\author{
Luis M. Rodriguez-R [aut, cre]
}
