% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tribs.R
\docType{class}
\name{enve.TRIBStest-class}
\alias{enve.TRIBStest-class}
\alias{enve.TRIBStest}
\title{Enveomics: TRIBS Test S4 Class}
\description{
Test of significance of overclustering or overdispersion in a selected
set of objects with respect to the entire set (see \code{\link{enve.TRIBS}}). This
object can be produced by \code{\link{enve.tribs.test}} and supports S4 methods
\code{plot} and \code{summary}.
}
\section{Slots}{

\describe{
\item{\code{pval.gt}}{\code{(numeric)}
P-value for the overdispersion test.}

\item{\code{pval.lt}}{\code{(numeric)}
P-value for the overclustering test.}

\item{\code{all.dist}}{\code{(numeric)}
Empiric PDF of distances for the entire dataset (subsampled at selection
size).}

\item{\code{sel.dist}}{\code{(numeric)}
Empiric PDF of distances for the selected objects (without subsampling).}

\item{\code{diff.dist}}{\code{(numeric)}
Empiric PDF of the difference between \code{all.dist} and \code{sel.dist}. 
The p-values are estimating by comparing areas in this PDF greater than and
lesser than zero.}

\item{\code{dist.mids}}{\code{(numeric)}
Midpoints of the empiric PDFs of distances.}

\item{\code{diff.mids}}{\code{(numeric)}
Midpoints of the empiric PDF of difference of distances.}

\item{\code{call}}{\code{(call)}
Call producing this object.}
}}

\author{
Luis M. Rodriguez-R [aut, cre]
}
