% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peaks.R
\name{GetIntegration}
\alias{GetIntegration}
\title{GetIntegration was mainly used for get the integration of certain ion's chromatogram data and plot the data}
\usage{
GetIntegration(
  data,
  rt = c(8.3, 9),
  n = 5,
  m = 5,
  slope = c(2, 2),
  baseline = 10,
  noslope = TRUE,
  smoothit = TRUE,
  half = FALSE
)
}
\arguments{
\item{data}{file should be a dataframe with the first column RT and second column intensity of the SIM ions.}

\item{rt}{a rough RT range contained only one peak to get the area}

\item{n}{points in the moving average smooth box, default value is 5}

\item{m}{numbers of points for regression to get the slope}

\item{slope}{the threshold value for start/stop peak as percentage of max slope}

\item{baseline}{numbers of the points for the baseline of the signal}

\item{noslope}{logical, if using a horizon line to get area or not}

\item{smoothit}{logical, if using an average smooth box or not. If using, n will be used}

\item{half}{logical, if using the left half peak to calculate the area}
}
\value{
integration data such as peak area, peak height, signal and the slope data.
}
\description{
GetIntegration was mainly used for get the integration of certain ion's chromatogram data and plot the data
}
\examples{
\dontrun{
list <- GetIntegration(data)
}
}
