% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{getmd}
\alias{getmd}
\title{Import data and return the annotated matrix for GC/LC-MS by m/z range and retention time}
\usage{
getmd(data, mzstep = 0.1, mzrange = FALSE, rtrange = FALSE)
}
\arguments{
\item{data}{file type which xcmsRaw could handle}

\item{mzstep}{the m/z step for generating matrix data from raw mass spectral data}

\item{mzrange}{vector range of the m/z, default all}

\item{rtrange}{vector range of the retention time, default all}
}
\value{
matrix with the row as increasing m/z second and column as increasing scantime
}
\description{
Import data and return the annotated matrix for GC/LC-MS by m/z range and retention time
}
\examples{
\dontrun{
library(faahKO)
cdfpath <- system.file('cdf', package = 'faahKO')
cdffiles <- list.files(cdfpath, recursive = TRUE, full.names = TRUE)
matrix <- getmd(cdffiles[1])
}
}
