% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attach_eval.R
\name{attach_eval}
\alias{attach_eval}
\title{Evaluate R expressions in an attached environment.}
\usage{
attach_eval(
  unquoted_expr,
  name = "local:utils",
  pos = 2L,
  warn.conflicts = TRUE,
  ...,
  expr = substitute(unquoted_expr),
  mask.ok = NULL
)
}
\arguments{
\item{unquoted_expr}{The expression to be evaluated, This is automatically
quoted.}

\item{name}{The environment name. If an environment of that name already
exists, it is reused, otherwise, a new environment is attached.}

\item{pos}{The position where to attach the environment, if creating a new
one. If an environment of \code{name} already exists, \code{pos} is ignored.}

\item{warn.conflicts}{logical. If TRUE (the default), print warnings about
objects in the attached environment that that are masking or masked by
other objects of the same name.}

\item{...}{Ignored.}

\item{expr}{An R language object. This is an escape hatch from the automatic
quoting of \code{unquoted_expr}.}

\item{mask.ok}{character vector of names of objects that can mask objects on
the search path without signaling a warning if \code{warn.conflicts} is \code{TRUE}.}
}
\value{
The result after evaluating \code{expr}, invisibly.
}
\description{
Evaluate R expressions in an attached environment.
}
\examples{
attach_eval({
  my_helper_funct <- function(x, y) x + y
})

search() # environment "local:utils" is now attached
my_helper_funct(1, 1) # the local utility is now available

detach(local:utils) # cleanup
}
