% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aridityIndexThornthwaite.R
\name{aridityIndexThornthwaite}
\alias{aridityIndexThornthwaite}
\title{aridityIndexThornthwaite}
\usage{
aridityIndexThornthwaite(precipStack, PETstack)
}
\arguments{
\item{precipStack}{rasterStack of monthly precipitation.}

\item{PETstack}{rasterStack of monthly potential evapotranspiration.}
}
\value{
RasterLayer, unitless
}
\description{
Generates thornthwaite aridity index raster.
}
\details{
\code{Thornthwaite aridity index = 100d / n}
where d = sum of monthly differences between precipitation and PET for months where precip < PET
where n = sum of monthly PET for those months
}
\examples{
\donttest{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
env <- stack(rasterFiles)

# identify the appropriate layers
meantemp <- grep('mean', names(env), value=TRUE)
solar <- grep('solrad', names(env), value=TRUE)
maxtemp <- grep('tmax', names(env), value=TRUE)
mintemp <- grep('tmin', names(env), value=TRUE)

# read them in as rasterStacks
meantemp <- stack(env[[meantemp]])
solar <- stack(env[[solar]])
maxtemp <- stack(env[[maxtemp]])
mintemp <- stack(env[[mintemp]])
tempRange <- abs(maxtemp - mintemp)

# get monthly PET
pet <- monthlyPET(meantemp, solar, tempRange)

precip <- grep('prec', names(env), value=TRUE)
precip <- stack(env[[precip]])

aridityIndexThornthwaite(precip, pet)
}

}
\references{
Thornthwaite, C.W. (1948). An approach toward a rational classification of climate.
\emph{Geographical Review}, \strong{38}, 55-94.
}
\seealso{
Requires rasters created with \code{\link{monthlyPET}}.
}
\author{
Pascal Title
}
