% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.R
\name{chebyshev.inequality.detect}
\alias{chebyshev.inequality.detect}
\title{Chebyshev inequality based identification of outliers on segments - Only intended for developer use}
\usage{
chebyshev.inequality.detect(x, cp.segment, L.default)
}
\arguments{
\item{x}{a numeric vector of data.}

\item{cp.segment}{an integer membership vector for individual segments.}

\item{L.default}{a numeric value of \emph{L} parameter determining the criterion for outlier detection:
the limits for outlier observations on individual segments are set as \eqn{+/- L * sample standard deviation of data on the corresponding segment}
If \code{L.default = NULL}, its value on individual segments is estimated using Algorithm A1 (Campulova et al., 2018).}
}
\value{
A list is returned with elements:
\item{L}{a numeric vector of \emph{L} parameters used for outlier identification on individual segments}
\item{outlier}{a logical vector specifing the identified outliers, \code{TRUE} means that corresponding data value from vector \code{x} is detected as outlier}
}
\description{
Identification of outlier data values on individual homogeneous segments using Chebyshev inequality.
The function is called by \code{\link{KRDetect.outliers.changepoint}} and is not intended for use by regular users of the package.
}
\details{
This function detects outlier observations on individual segments using Chebyshev inequality.
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function for identification of outlier residuals.
}
\references{
Campulova M, Michalek J, Mikuska P, Bokal D (2018). Nonparametric algorithm for identification of outliers in environmental data. Journal of Chemometrics, 32, 453-463.
}
