% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{smoothing}
\alias{smoothing}
\title{Kernel regression smoothing - Only intended for developer use}
\usage{
smoothing(x, y, bandwidth.type, bandwidth.value)
}
\arguments{
\item{x}{a numeric vector of design points.}

\item{y}{a numeric vector of data values of the same length as \code{x}.}

\item{bandwidth.type}{a character string specifying the type of bandwidth, must be \code{"local"} or \code{"global"}.}

\item{bandwidth.value}{a local bandwidth array (for \code{bandwidth.type = "local"}) or global bandwidth value (for \code{bandwidth.type = "global"}) for kernel regression estimation. If \code{bandwidth.type = "NULL"} (default) a data-adaptive local plug-in (Herrmann, 1997) (for \code{bandwidth.type = "local"}) or data-adaptive global plug-in (Gasser et al., 1991) (for \code{bandwidth.type = "global"}) bandwidth is used instead.}
}
\value{
A numeric vector of estimates of the kernel regression function (smoothed data).
}
\description{
Nonparametric estimation of regression function using kernel regression with local or global data-adaptive plug-in bandwidth.
The function is called by \code{\link{KRDetect.outliers.changepoint}}, \code{\link{KRDetect.outliers.controlchart}} and \code{\link{KRDetect.outliers.EV}}. This function is not intended for use by regular users of the package.
}
\details{
This function computes the estimate of kernel regression function using a local or global data-adaptive plug-in algorithm.
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function for computing estimates of the kernel regression function using functions implemented in package \pkg{lokern}.
}
\references{
Gasser T, Kneip A, Kohler W (1991). A flexible and fast method for automatic smoothing. Journal of the American Statistical Association, 86, 643–652.

Herrmann E (1997). Local bandwidth choice in kernel regression estimation. Journal of Computational and Graphical Statistics, 6(1), 35–54.

Eva Herrmann; Packaged for R and enhanced by Martin Maechler (2016). lokern: Kernel Regression Smoothing with Local or Global Plug-in Bandwidth. R package version 1.1-8. https://CRAN.R-project.org/package=lokern
}
